unit untAEE;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TfrmAEE = class(TForm)
    txtA: TEdit;
    txtB: TEdit;
    lblTitulo: TLabel;
    cmdCompleto: TBitBtn;
    lblSaida: TLabel;
    cmdSair: TBitBtn;
    Creditos: TLabel;
    lblRefSaida: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    cmdMDC: TBitBtn;
    lblPrimos: TLabel;
    cmdLimpar: TBitBtn;
    procedure cmdSairClick(Sender: TObject);
    procedure cmdCompletoClick(Sender: TObject);
    procedure txtBChange(Sender: TObject);
    procedure txtAKeyPress(Sender: TObject; var Key: Char);
    procedure txtBKeyPress(Sender: TObject; var Key: Char);
    procedure cmdLimparClick(Sender: TObject);
    procedure cmdMDCClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmAEE: TfrmAEE;

implementation
      type Vetor = array[1..2] of integer;
      var a,b,r,RestoAnt,q,i1,i2:integer;
          Saida:string;
{$R *.DFM}

{ ************* Atualiza os coeficientes }
Procedure Atualiza_Coef(var C:vetor);
var aux:integer;
begin
   aux:=C[1];
   C[1]:=C[2]-q*C[1];
   C[2]:=aux;
end;

{ ****************  Fecha o programa ******************}
procedure TfrmAEE.cmdSairClick(Sender: TObject);
begin
  frmAEE.Close;
end;

{ ************  Limpar Campos ********************}
procedure TfrmAEE.cmdLimparClick(Sender: TObject);
begin
   txtA.ReadOnly := false;
   txtB.ReadOnly := false;
   txtA.Text := '';
   txtB.Text := '';
   lblSaida.Caption := '';
   cmdcompleto.Enabled := false;
   cmdMDC.Enabled := false;
   txtA.SetFocus;
   cmdLimpar.Enabled := false;
   Creditos.Visible := false;
   lblRefSaida.Visible := false;
   lblPrimos.Visible := false;
end;

{ **************  S o MDC - Algortmo simples **************}
 procedure TfrmAEE.cmdMDCClick(Sender: TObject);
begin

        Val(txtA.text,a,i1);
        Val(txtB.text,b,i2);
        If (i1 <> 0)or(i2 <> 0)
            then
                 begin {  Tratamento de erros da entrada   }
                      Showmessage('Digite caracteres vlidos para o clculo!!');
                      If i1 <> 0 then txtA.SetFocus
                                 else txtB.SetFocus;
                 end
            else
                 begin { Algoritmo - Clculo}
                     RestoAnt:=b;
                     r:= a mod b;
                     While r <> 0 do
                         begin
                          RestoAnt:=r;
                          r:= a mod b;
                          a:=b;
                          b:=r;
                         end;
                     if RestoAnt = 1           { Escrevendo Saida }
                        then
                           lblPrimos.Visible := true
                        else
                           lblPrimos.Visible := false;
                     txtA.ReadOnly := true;
                     txtB.ReadOnly := true;
                     Saida:= 'O MDC  ' + InttoStr(RestoAnt);
                     lblSaida.Caption := Saida;
                     lblRefSaida.Visible := false;
                     cmdLimpar.Enabled := true;
                     Creditos.Visible := true;
                     cmdCompleto.SetFocus;
                 end;
end;

{ ****** Executa o clculo do MDC com o algor. Euclid. Extend. ****}

procedure TfrmAEE.cmdCompletoClick(Sender: TObject);
var m,n:integer; {Quarda a e b}
    x,y:Vetor; {Usado para calcular os coeficientes da expresso geral}
begin
        Val(txtA.text,a,i1);
        Val(txtB.text,b,i2);
        If (i1 <> 0)or(i2 <> 0)
            then
                 begin {  Tratamento de erros da entrada   }
                      Showmessage('Digite caracteres vlidos para o clculo!!');
                      If i1 <> 0 then txtA.SetFocus
                                 else txtB.SetFocus;
                 end
            else
                 begin { Algoritmo Euclidiano Estendido - Clculo}
                     m:=a;
                     n:=b;
                     x[1]:=0;
                     x[2]:=1;
                     y[1]:=1;
                     y[2]:=0;
                     r:= a mod b;
                     While r <> 0 do
                         begin
                          RestoAnt:=r;
                          r:= a mod b;
                          q:= a div b;
                          Atualiza_Coef(x);
                          Atualiza_Coef(y);
                          a:=b;
                          b:=r;
                         end;
                     if m mod n = 0      { Escrevendo Saida }
                        then
                            Saida:= ' 0 . ' + txtA.Text + ' + 1 . ' + txtB.Text + ' = ' + inttostr(RestoAnt)
                        else
                            Saida:= InttoStr(x[2])+ ' . ' + txtA.Text + ' + (' + Inttostr(y[2]) + ') . ' + txtB.Text + ' = ' + inttostr(RestoAnt);
                     if RestoAnt = 1
                        then
                           lblPrimos.Visible := true
                        else
                           lblPrimos.Visible := false;
                     txtA.ReadOnly := true;
                     txtB.ReadOnly := true;
                     lblSaida.Caption := Saida;
                     lblRefSaida.Visible := true;
                     cmdLimpar.Enabled := true;
                     Creditos.Visible := true;
                     cmdLimpar.SetFocus;
                 end;
end;

{ ***** Abilita o cmdCalcular quando entradas preenchidas ********}

procedure TfrmAEE.txtBChange(Sender: TObject);
begin
if (txtA.Text <> '') and (txtB.Text <> '')
      then
          Begin
           cmdcompleto.Enabled := true;
           cmdMDC.Enabled := true;
          end
      else
          Begin
           cmdcompleto.Enabled := false;
           cmdMDC.Enabled := false;
          end;
end;

{ ****************  Mudar focos com Enter **************}
procedure TfrmAEE.txtAKeyPress(Sender: TObject; var Key: Char);
begin
if Ord(key)=13 then
   txtB.SetFocus;
end;

procedure TfrmAEE.txtBKeyPress(Sender: TObject; var Key: Char);
begin
if Ord(key)=13 then
   cmdMDC.SetFocus;
end;
End.

