unit untPrincipal;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Gauges;

type
  TfrmPrincipal = class(TForm)
    edtTexto: TEdit;
    Label1: TLabel;
    cmdCodificar: TBitBtn;
    cmdDecodificar: TBitBtn;
    cmdSair: TBitBtn;
    GroupBox1: TGroupBox;
    edtQ: TEdit;
    edtP: TEdit;
    edtE: TEdit;
    edtN: TEdit;
    edtD: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    cmdChave: TBitBtn;
    cmdCancelar: TBitBtn;
    lblAjuda1: TLabel;
    cmdNotas: TBitBtn;
    cmdCreditos: TBitBtn;
    lblAjuda3: TEdit;
    lblAjuda2: TEdit;
    lblAjuda4: TLabel;
   { procedure cmdConfigurarClick(Sender: TObject); }
    procedure cmdChaveClick(Sender: TObject);
    procedure cmdCodificarClick(Sender: TObject);
    procedure cmdDecodificarClick(Sender: TObject);
    procedure cmdSairClick(Sender: TObject);
    procedure cmdCancelarClick(Sender: TObject);
    procedure edtEChange(Sender: TObject);
    procedure edtQDblClick(Sender: TObject);
    procedure edtPDblClick(Sender: TObject);
    procedure edtEDblClick(Sender: TObject);
    procedure cmdChaveMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure cmdCodificarMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure cmdDecodificarMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure cmdSairMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure cmdNotasMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure cmdCreditosMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure cmdCreditosClick(Sender: TObject);
    procedure cmdCancelarMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure GroupBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure cmdNotasClick(Sender: TObject);
    procedure edtNKeyPress(Sender: TObject; var Key: Char);
    procedure edtDKeyPress(Sender: TObject; var Key: Char);
    procedure edtEKeyPress(Sender: TObject; var Key: Char);
    procedure edtQKeyPress(Sender: TObject; var Key: Char);
    procedure edtPKeyPress(Sender: TObject; var Key: Char);
    procedure edtTextoKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmPrincipal: TfrmPrincipal;

implementation

uses untConfigura, Unit1;

{$R *.DFM}
 type
       GrandNum = Currency; {int64; }

       Vcod= array[1..300] of GrandNum;

 var p,q,e,n,d:GrandNum;
     Blocos:Vcod;
     texto:string;
     textocod:string;

 Const Sep = '/';


{ ****** Executa o clculo do MDC com o algor. Euclid. Extend. *****************}
procedure MDCEuclid(a,b:GrandNum;var valD,mdc:GrandNum);
type Vetor = array[1..2] of integer;
      var r,quoef,i1,i2:integer;
          Saida:string;
var m,n,RestoAnt:GrandNum; {Quarda a e b}
    x,y:Vetor; {Usado para calcular os coeficientes da expresso geral}


           {***** Atualiza os coeficientes *********}
              Procedure Atualiza_Coef(var C:vetor);
              var aux:integer;
                begin
                   aux:=C[1];
                   C[1]:=C[2]-quoef*C[1];
                   C[2]:=aux;
                end;

begin
               { Algoritmo Euclidiano Estendido - Clculo}
                     m:=a;
                     n:=b;
                     a:= Abs(a);
                     b:= Abs(b);
                     RestoAnt :=0;
                     x[1]:=0;
                     x[2]:=1;
                     y[1]:=1;
                     y[2]:=0;
                     If (b <> 0) {Tratando o 0 }
                         then
                              r:= Round(a) mod Round(b)
                         else
                           Begin
                              r:= 0;
                              RestoAnt := a;
                           end;
                     While r <> 0 do
                         begin
                          RestoAnt:=r;
                          r:= Round(a) mod Round(b);
                          quoef:= Round(a) div Round(b);
                          Atualiza_Coef(x);
                          Atualiza_Coef(y);
                          a:=b;
                          b:=r;
                         end;

                     If (m < 0)  { Escrevendo Saida }
                         then x[2]:= -x[2];
                     If (n < 0)
                         then y[2]:= -y[2];

                     if (n = 0)
                         then
                            begin
                               mdc := RestoAnt;
                               If m < 0
                                   then
                                        valD := -1
                                   else
                                        valD := 1;
                            end
                         else
                             If  (Round(m) mod Round(n) = 0)
                                then
                                   begin
                                     mdc := RestoAnt;
                                     If n < 0
                                         then
                                               valD := -1
                                         else
                                               valD := 1;
                                   end
                                else
                                     begin
                                         mdc := RestoAnt;
                                         valD := x[2];
                                      end;
                                     {Saida:= InttoStr(x[2])+ ' . ' + txtA.Text + ' + (' + Inttostr(y[2]) + ') . ' + txtB.Text + ' = ' + inttostr(RestoAnt); }

end;
{ ********************************************************************************}

function Seprimo(num:GrandNum):boolean;
var f:integer;
Begin
    f:=2;
    while (Round(num) mod f <> 0 )and (f*f <=num )  do
         Inc(f);
    If (Round(num) mod f = 0 )
         then
              Seprimo:=false
         else
              Seprimo:=true;


End;

procedure TfrmPrincipal.cmdChaveClick(Sender: TObject);

begin
edtQ.Enabled := true;
edtP.Enabled := true;
edtE.Enabled := true;
edtQ.Color := clWindow;
edtP.Color := clWindow;
edtE.Color := clWindow;
edtQ.SetFocus;
cmdCodificar.Enabled :=false;
cmdDecodificar.Enabled :=false;
cmdCancelar.Enabled := true;
lblAjuda1.Visible := true;

end;

procedure TfrmPrincipal.cmdCodificarClick(Sender: TObject);
begin
edtN.Enabled := true;
edtE.Enabled := true;
edtTexto.Enabled := true;
edtE.Color := clWindow;
edtN.Color := clWindow;
edtTexto.Color := clWindow;
edtTexto.SetFocus;
cmdDecodificar.Enabled:= false;
cmdChave.Enabled := false;
cmdCancelar.Enabled := true;
end;

procedure TfrmPrincipal.cmdDecodificarClick(Sender: TObject);
begin
edtD.Enabled := true;
edtN.Enabled := true;
edtTexto.Enabled := true;
edtD.Color := clWindow;
edtN.Color := clWindow;
edtTexto.Color := clWindow;
edttexto.SetFocus;
cmdCodificar.Enabled := false;
cmdChave.Enabled := false;
cmdCancelar.Enabled := true;
lblAjuda4.Visible:= true;
end;

procedure TfrmPrincipal.cmdSairClick(Sender: TObject);
begin
frmPrincipal.Close;
end;
 {*************** LIMPEZA DO VETOR **********************************}

 Procedure Limpa(var vetor:Vcod);
 var j:integer;
 begin
  for j:=1 to 300 do
      Vetor[j] := 0;

 end;

 { *************** PROCEDIMENTO DE CODIFICAO **********************}

 Procedure Codifica(var num:GrandNum);
 var  ValorE,p:GrandNum;
 begin
     p := 1;
     ValorE := e;
     while ValorE > 0 do
           begin
           If Round(ValorE) mod 2 = 1
               then p := Round(p * num) mod Round(n);
           ValorE := Round(ValorE) div 2;
           Num := Round(Num * Num) mod Round(n);
           end;
     num := p;
 end;

 { *************** PROCEDIMENTO DE DECODIFICAO **********************}

 Procedure Decodifica(var num:GrandNum);
  var  ValorD:GrandNum; p:integer;
 begin
     p := 1;
     ValorD := d;
     while ValorD > 0 do
           begin
           If Round(ValorD) mod 2 = 1
               then p := Round(p * num) mod Round(n);
           ValorD := Round(ValorD) div 2;
           Num := Round(Num * Num) mod Round(n);
           end;
     num := p;

 end;

{ ***************  BOTO DE AES ( MULTIFUNO ) ****************************}
procedure TfrmPrincipal.cmdCancelarClick(Sender: TObject);
 var aux1, aux2, aux3,i,tam: integer; Vmdc,auxgrande:GrandNum;
     StrBloco:string[14]; saida:String;
begin
try {tratando erros. inicio da superviso}
aux1:= 0;aux2:=0; aux3:= 0; i:=0;
if (cmdCancelar.Caption = 'Cancelar')or(cmdCancelar.Caption = 'Resetar')
then
begin  { Caso o Nome do Boto seja RESETAR ou CANCELAR }
     edtQ.Enabled := false;
     edtP.Enabled := false;
     edtE.Enabled := false;
     edtD.Enabled := false;
     edtN.Enabled := false;
     edtTexto.Enabled := false;
     edtTexto.Color := clMenu;
     edtQ.Color := clMenu;
     edtP.Color := clMenu;
     edtD.Color := clMenu;
     edtE.Color := clMenu;
     edtN.Color := clMenu;
     cmdCodificar.Enabled := true;
     cmdChave.Enabled := true;
     cmdDecodificar.Enabled := true;
     cmdCancelar.Enabled := false;
     edtQ.Text := '';
     edtP.Text := '';
     edtN.Text := '';
     edtE.Text := '';
     edtD.Text := '';
     lblAjuda1.Visible := false;
     lblAjuda4.Visible:= false;
end
else { ************* Clculos para a chave (Nome do boto = OK) ************}
    if cmdCancelar.Caption = 'OK'
        then
           begin
           q:= StrtoInt(edtQ.text);
           p:= StrtoInt(edtP.text);
           e:= StrtoInt(edtE.text);
           {** Usar VAL se GrandNum for longint **}
           {Val(edtQ.text,q,aux1);
           Val(edtP.text,p,aux2);
           Val(edtE.text,e,aux3); }

           If (aux1 <> 0) or  (aux2 <> 0) or (aux3 <> 0)
             then
               messagedlg('Digite nmeros vlidos!',mtError,[mbOK],0)
             else
                begin
                if Seprimo(q) and Seprimo(p)
                   then
                        begin
                        n := p*q;
                        MDCEuclid(e,(p-1)*(q-1),d,Vmdc);
                        If Vmdc <> 1
                            then
                                begin
                                messagedlg('Escolha um nmero "e" tal que mdc(e,(p-1)*(q-1)) = 1!',mtError,[mbOK],0);
                                edtE.SetFocus;
                                end
                            else
                                begin
                                edtN.Text := Inttostr(Round(n));
                                edtD.text := Inttostr(Round(d));
                                cmdCancelar.caption := 'Resetar';
                                edtQ.Enabled := false;
                                edtP.Enabled := false;
                                edtE.Enabled := false;
                                cmdChave.Enabled := false;
                                end;
                        end
                   else
                       if not Seprimo(q)
                            then messagedlg('O Nmero "q" no  primo!',mtError,[mbOK],0)
                            else if not Seprimo(p)
                                       then messagedlg('O Nmero "p" no  primo!',mtError,[mbOK],0)
                                       else messagedlg('Um dos nmeros, "p" ou "q", no  vlido!',mtError,[mbOK],0);
                   end;
           end
        else {Se nao for OK...}
           If cmdCancelar.Caption = 'Criptografar' {Se o nome do boto =Criptografar}
               then
                   begin
                   n := StrtoInt(edtN.text);
                   e := StrtoInt(edtE.text);
                   Limpa(blocos);
                   {Val(edtN.text,n,aux2);{usar VAL se GrandNum for longint
                   Val(edtE.text,e,aux3); }
                   if (aux2 <> 0) or(aux3 <> 0)
                       then messagedlg('Chave invlida!',mtError,[mbOK],0)
                       else
                           begin
                           texto := edtTexto.text;
                           textocod := '';
                           for i := 1 to length(texto)do  {convertendo p/ uma string de nmeros}
                                textocod := textocod + inttostr(ord(texto[i]));
                           i:=0;
                           aux1 := 1;
                           repeat { Guardando, num vetor de inteiros, os blocos gerados com tamanhos aleatrios}
                                Inc(i);
                                repeat
                                    repeat
                                    {randomize; }
                                    aux2 := random(length(EdtN.Text)-1);
                                    until aux2 >= 2;
                                    StrBloco :=copy(textocod,aux1,aux2);
                                    blocos[i]:= StrtoInt(StrBloco);
                                until (n > blocos[i]) and (textocod[aux1 + aux2] <> '0') ;
                                Aux1 := Aux1 + Aux2;

                           until  Aux1 > length(textocod);
                           for aux3 := 1 to i do { Verificando se o Mdc(bloco,n) = 1}
                                begin
                                MDCEuclid(blocos[aux3],n,auxgrande,Vmdc);
                                If Vmdc <> 1
                                     then messagedlg('Chave quebrada!',mtError,[mbOK],0);
                                end;
                           end;

                           for aux3 := 1 to i do {Codificao }
                                Codifica(blocos[aux3]);
                           edtTexto.Text := '';   {Exibe na tela}
                           textocod := '';
                           for aux3 := 1 to i do
                               textocod := textocod + InttoStr(Round(blocos[aux3])) + Sep;
                           Delete(textocod,length(textocod),1);
                           EdtTexto.Text := textocod;
                           cmdCancelar.caption := 'Resetar';
                           edtN.Enabled := false;
                           edtE.Enabled := false;
                           cmdcodificar.Enabled := false;
                   end {end da parte "Codificao"}
               else { Se nome do boto = Decodificar}
                    Begin {Inicio da parte "Decodificao"}
                    n := StrtoInt(edtN.text);
                    d := StrtoInt(edtD.text);
                    Limpa(blocos);
                   { Val(edtN.text,n,aux2);
                    Val(edtD.text,d,aux3);  USAR VAL SE GRANDNUM FOR UM LONGINT}
                    if (aux2 <> 0) or(aux3 <> 0)
                        then messagedlg('Chave invlida!',mtError,[mbOK],0)
                        else
                            Begin {Separando a mensagem em blocos fornecidos por edtTexto}
                            TextoCod := edtTexto.Text;
                            TextoCod := TextoCod + Sep; {Sentinela para final da separao por blocos}
                            tam := length(TextoCod);
                            aux1 := 1;
                            aux2 := 1;
                            i:=0;
                            Repeat
                                 inc(i);
                                 repeat
                                     Inc(aux2);
                                 until (textocod[aux2] = Sep);{ or (aux2-aux1 > length(edtD.text)); }
                                 aux3 := 0;
                                 if (aux2 > tam) or (Pos(Sep,textocod) = 0)
                                     then
                                          begin
                                          messagedlg('Mensagem invlida!',mtError,[mbOK],0);
                                          aux3 := 1;  {p/ sair}
                                          end
                                     else
                                         begin
                                         blocos[i]:= StrtoInt( copy(textocod,aux1,aux2-aux1));
                                         {Val(copy(textocod,aux1,aux2-aux1), blocos[i],aux3); }
                                         if aux3 <> 0
                                              then messagedlg('Mensagem invlida!',mtError,[mbOK],0)
                                              else  {ajuste p/ prxima iterao}
                                                  begin
                                                      aux1 := aux2+1;
                                                      {aux2 := aux1-1;}
                                                  end;
                                         end;
                            until (aux3 <> 0) or (aux1 {+ i-2} > length(textocod)-1);
                            If Aux3 <> 0
                               then messagedlg('No  possvel descriptografar! Alguns blocos grandes demais ou no separados corretamente por "'+sep+'".',mtError,[mbOK],0)
                               else
                                   begin
                                       for aux1 := 1 to i do
                                               Decodifica(blocos[aux1]);
                                       edtTexto.Text := '';   {Exibe na tela}
                                       textocod := '';
                                       for aux3 := 1 to i + 1 do
                                           textocod := textocod + IntToStr(Round(blocos[aux3]));
                                       for aux3 :=1 to length(textocod) do
                                            if aux3 mod 2 = 1
                                                then Saida := Saida + Chr(Strtoint(copy(textocod,aux3,2)));
                                       EdtTexto.Text := Saida;
                                       cmdCancelar.caption := 'Resetar';
                                       edtD.Enabled := false;
                                       edtN.Enabled := false;
                                       cmdDecodificar.Enabled := false;
                                   end;

                            end;

                  end;
except {Tratando erros}
On EConvertError do
   messagedlg('Caracteres no nmericos para "p","q","e","d" ou "n"!',mtError,[mbOK],0);
On EAccessViolation do
   messagedlg('Falha da converso de dados. Acesso a uma regio/verivel invlida.',mtError,[mbOK],0);
On EIntOverFlow do
   messagedlg('Estouro de varivel inteira.',mtError,[mbOK],0);
On EOverFlow do
   messagedlg('Estouro de varivel real.',mtError,[mbOK],0);
On EInvalidOp do
   messagedlg('Operao no permitida para nmeros reais.',mtError,[mbOK],0);
else
   messagedlg('Erro no determinado. Se este erro persistir, comunique-se com o suporte tcnico.',mtError,[mbOK],0);
end; {fim do try}
end;

procedure TfrmPrincipal.edtEChange(Sender: TObject);
begin
cmdCancelar.Caption := 'Cancelar';

if (edtP.Text <> '') and (edtQ.Text <> '') and (edtE.Text <> '')and
 (cmdCodificar.Enabled = false) and (cmdDecodificar.Enabled = false)
 then cmdCancelar.Caption := 'OK';

If (edtN.Text <> '') and (edtE.Text <> '') and
  (cmdChave.Enabled = false) and (cmdDecodificar.Enabled = false)
  then cmdCancelar.Caption := 'Criptografar';

If (edtD.Text <> '') and (edtN.Text <> '')and
(cmdChave.Enabled = false) and (cmdCodificar.Enabled = false)
  then cmdCancelar.Caption := 'Descriptografar';
end;


{ ********************  GERANDO NMEROS ALEATRIOS ****************************}
Function GeraRandom(num:integer):Longint;
var Rand:Longint;
    cont:integer;
begin
   Randomize;
   cont:=0;
   repeat
       Inc(Cont);
       Rand := Random(num);
   until (Seprimo(Rand)) or (Cont > 50);
   GeraRandom := Rand;
end;

procedure TfrmPrincipal.edtQDblClick(Sender: TObject);
begin
edtQ.Text := InttoStr(GeraRandom(5000));
end;

procedure TfrmPrincipal.edtPDblClick(Sender: TObject);
begin
edtP.Text := InttoStr(GeraRandom(5000));
end;

procedure TfrmPrincipal.edtEDblClick(Sender: TObject);
begin
if cmdChave.Enabled then
edtE.Text := InttoStr(GeraRandom(200));
end;


{ *************** Mudar Cor dos Botes *************************************}
procedure TfrmPrincipal.cmdChaveMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
cmdChave.Font.Color := clblue;
cmdcodificar.Font.Color := clBlack;
end;

procedure TfrmPrincipal.cmdCodificarMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
cmdCodificar.Font.Color := clblue;
cmdDecodificar.Font.Color := clBlack;
cmdchave.Font.Color := clBlack;
end;


procedure TfrmPrincipal.cmdCancelarMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
cmdCancelar.Font.Color := clblue;
end;

procedure TfrmPrincipal.GroupBox1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
cmdCancelar.Font.Color := clblack;
end;
procedure TfrmPrincipal.cmdDecodificarMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
cmdDecodificar.Font.Color := clblue;
cmdSair.Font.Color := clBlack;
cmdcodificar.Font.Color := clBlack;
end;

procedure TfrmPrincipal.cmdSairMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
cmdSair.Font.Color := clblue;
cmdDecodificar.Font.Color := clBlack;
end;

procedure TfrmPrincipal.FormMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
 cmdDecodificar.Font.Color := clBlack;
 cmdSair.Font.Color := clBlack;
 cmdcodificar.Font.Color := clBlack;
 cmdchave.Font.Color := clBlack;
 lblAjuda2.Visible := false;
 lblAjuda3.Visible := false;
 cmdCancelar.Font.Color := clblack;
end;



procedure TfrmPrincipal.cmdNotasMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
lblAjuda2.Visible := true;
lblAjuda3.Visible := false;
end;

procedure TfrmPrincipal.cmdCreditosMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
lblAjuda3.Visible := true;
lblAjuda2.Visible := false;
end;

{ *************  BOTES: CRDITOS E NOTEPAD *********************************}

procedure TfrmPrincipal.cmdCreditosClick(Sender: TObject);
begin
Aboutbox.show;
end;

procedure TfrmPrincipal.cmdNotasClick(Sender: TObject);
begin
lblAjuda2.Visible := false;
WinExec('Notepad.exe',sw_show);
end;


{ ************  TRATAMENTO DAS ENTRADAS NUMRICAS E DE TEXTO *****************}
procedure TfrmPrincipal.edtNKeyPress(Sender: TObject; var Key: Char);
begin
 if not((Key in ['0'..'9'])or (Ord(key) = 8)) then
    key := #0;
end;

procedure TfrmPrincipal.edtDKeyPress(Sender: TObject; var Key: Char);
begin
if not((Key in ['0'..'9'])or (Ord(key) = 8)) then
    key := #0;
end;

procedure TfrmPrincipal.edtEKeyPress(Sender: TObject; var Key: Char);
begin
if not((Key in ['0'..'9'])or (Ord(key) = 8)) then
    key := #0;
end;

procedure TfrmPrincipal.edtQKeyPress(Sender: TObject; var Key: Char);
begin
if not((Key in ['0'..'9'])or (Ord(key) = 8)) then
    key := #0;
end;

procedure TfrmPrincipal.edtPKeyPress(Sender: TObject; var Key: Char);
begin
if not((Key in ['0'..'9'])or (Ord(key) = 8)) then
    key := #0;
end;

procedure TfrmPrincipal.edtTextoKeyPress(Sender: TObject; var Key: Char);
begin
if (Ord(key) > 122) then  { NO DEIXA ESCREVER LETRAS COM ACENTUAO GRFICA }
    key := #0;
end;

end.
